/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import wafflestomper.ghostwriter.Ghostwriter;
import wafflestomper.ghostwriter.gui.GuiUtils;
import wafflestomper.ghostwriter.gui.IGhostBook;
import wafflestomper.ghostwriter.gui.screen.GhostwriterEditBookScreen;
import wafflestomper.ghostwriter.gui.screen.GhostwriterFileBrowserScreen;
import wafflestomper.ghostwriter.gui.screen.GhostwriterSignedPreviewScreen;
import wafflestomper.ghostwriter.utilities.Clipboard;
import wafflestomper.ghostwriter.utilities.FileHandler;
import wafflestomper.ghostwriter.utilities.Printer;

public class GhostLayer {
    private Button buttonDisableAutoReload;
    private Button buttonPasteBook;
    private Button buttonCutMultiplePages;
    private Button buttonSelectPageA;
    private Button buttonSelectPageB;
    private Button buttonCopySelectedPages;
    private Button buttonPasteMultiplePages;
    private Button buttonRemoveSelectedPages;
    private final List<Button> buttonsHideWhileSigning = new ArrayList<Button>();
    private final List<Button> buttonsEditOnly = new ArrayList<Button>();
    private int colorFormatButtonX = 0;
    private int selectedPageA = -1;
    private int selectedPageB = -1;
    private File autoReloadFile;
    public long autoReloadLastModified = 0L;
    private long autoReloadLastCheck = 0L;
    private Clipboard autoReloadClipboard;
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private final IGhostBook parent;
    public final Screen screen;
    public final boolean bookIsEditable;
    private String bookTitle = "";
    private String bookAuthor = "";
    private boolean buttonsInitialized = false;

    public GhostLayer(IGhostBook parent, Screen screenParent, boolean bookIsEditable) {
        this.parent = parent;
        this.screen = screenParent;
        this.bookIsEditable = bookIsEditable;
    }

    public String getBookAuthor() {
        return this.bookAuthor;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String title) {
        this.bookTitle = title.length() < 32 ? title : title.substring(0, 32);
    }

    public void extractTitleAuthor(ItemStack bookStack) {
        if (bookStack == null) {
            return;
        }
        CompoundTag compoundnbt = bookStack.m_41783_();
        if (compoundnbt == null) {
            return;
        }
        this.setBookTitle(compoundnbt.m_128461_("title"));
        this.bookAuthor = compoundnbt.m_128461_("author");
    }

    private void bookChanged(boolean resetPageSelection) {
        if (resetPageSelection) {
            this.selectedPageA = -1;
            this.selectedPageB = -1;
        }
        this.parent.bookChanged(true);
        this.updateButtons();
    }

    private void copyBook() {
        Ghostwriter.GLOBAL_CLIPBOARD.author = "";
        Ghostwriter.GLOBAL_CLIPBOARD.title = this.bookTitle;
        Ghostwriter.GLOBAL_CLIPBOARD.pages.clear();
        Ghostwriter.GLOBAL_CLIPBOARD.pages.addAll(this.parent.pagesAsList());
        Ghostwriter.GLOBAL_CLIPBOARD.bookInClipboard = true;
        Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Book copied");
        this.updateButtons();
    }

    private void copySelectedPagesToClipboard() {
        int firstPage = Math.min(this.selectedPageA, this.selectedPageB);
        int lastPage = Math.max(this.selectedPageA, this.selectedPageB);
        if (firstPage == -1 || lastPage == -1) {
            firstPage = this.parent.getCurrPage();
            lastPage = this.parent.getCurrPage();
        }
        if (firstPage >= 0 && lastPage >= firstPage && lastPage < this.parent.getBookPageCount()) {
            Ghostwriter.GLOBAL_CLIPBOARD.miscPages.clear();
            List<String> pagesAsList = this.parent.pagesAsList();
            for (int i = firstPage; i <= lastPage; ++i) {
                Ghostwriter.GLOBAL_CLIPBOARD.miscPages.add(pagesAsList.get(i));
            }
            Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Selection copied");
        } else {
            Ghostwriter.PRINTER.gamePrint(Printer.RED + "Invalid selection! Copy aborted.");
        }
        this.updateButtons();
    }

    private void cutMultiplePages() {
        int from = Math.min(this.selectedPageA, this.selectedPageB);
        int to = Math.max(this.selectedPageA, this.selectedPageB);
        if (from < 0 || from >= this.parent.getBookPageCount() || to >= this.parent.getBookPageCount()) {
            from = this.parent.getCurrPage();
            to = this.parent.getCurrPage();
        }
        Ghostwriter.GLOBAL_CLIPBOARD.miscPages.clear();
        List<String> pagesAsList = this.parent.pagesAsList();
        for (int i = from; i <= to; ++i) {
            Ghostwriter.GLOBAL_CLIPBOARD.miscPages.add(pagesAsList.get(i));
        }
        this.removePages(this.selectedPageA, this.selectedPageB);
        this.bookChanged(true);
        Ghostwriter.PRINTER.gamePrint(Printer.GRAY + Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() + " page" + (Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() == 1 ? "" : "s") + " cut");
    }

    private void insertPage() {
        if (this.parent.getBookPageCount() < 100) {
            this.parent.insertNewPage(this.parent.getCurrPage(), "");
            Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Page inserted");
            this.bookChanged(false);
        } else {
            Ghostwriter.PRINTER.gamePrint(Printer.RED + "Cannot add another page! Book is full!");
        }
    }

    private void pasteBook() {
        this.clipboardToBook(Ghostwriter.GLOBAL_CLIPBOARD);
        this.bookChanged(true);
        Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Book pasted");
    }

    private void pasteMultiplePages(int startPos) {
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos >= this.parent.getBookPageCount()) {
            startPos = this.parent.getBookPageCount() - 1;
        }
        List<String> oldBook = this.parent.pagesAsList();
        int newBookSize = this.parent.getBookPageCount() + Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size();
        for (int i = startPos; i < newBookSize; ++i) {
            if (i >= this.parent.getBookPageCount()) {
                this.parent.insertNewPage(this.parent.getBookPageCount(), "");
            }
            if (i >= startPos + Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size()) {
                this.parent.setPageText(i, oldBook.get(i - Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size()));
                continue;
            }
            this.parent.setPageText(i, Ghostwriter.GLOBAL_CLIPBOARD.miscPages.get(i - startPos));
        }
        this.bookChanged(true);
        Ghostwriter.PRINTER.gamePrint(Printer.GRAY + Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() + " page" + (Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() == 1 ? "" : "s") + " pasted");
    }

    private void addSignaturePages() {
        Clipboard temp = new Clipboard();
        Clipboard clip = new Clipboard();
        temp.clone(Ghostwriter.GLOBAL_CLIPBOARD);
        Ghostwriter.GLOBAL_CLIPBOARD.clearBook();
        Ghostwriter.GLOBAL_CLIPBOARD.miscPages.clear();
        FileHandler fh = new FileHandler(clip);
        File sigFile = new File(Ghostwriter.FILE_HANDLER.getSignaturePath(), "default.ghb");
        if (fh.loadBook(sigFile) && clip.bookInClipboard) {
            this.parent.insertNewPage(this.parent.getBookPageCount(), "");
            Ghostwriter.GLOBAL_CLIPBOARD.miscPages.addAll(clip.pages);
            this.pasteMultiplePages(this.parent.getBookPageCount() - 1);
            Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Signature pages added");
            this.removePages(this.parent.getBookPageCount() - 1, this.parent.getBookPageCount() - 1);
        } else {
            Ghostwriter.PRINTER.gamePrint(Printer.RED + "Couldn't load " + sigFile + " Does it exist?");
        }
        Ghostwriter.GLOBAL_CLIPBOARD.clone(temp);
    }

    private void removePages(int start, int end) {
        int from = Math.min(start, end);
        int to = Math.max(start, end);
        if (from < 0 || from >= this.parent.getBookPageCount() || to >= this.parent.getBookPageCount()) {
            from = this.parent.getCurrPage();
            to = this.parent.getCurrPage();
        }
        if (from > 0) {
            this.parent.setCurrPage(from - 1);
        } else {
            this.parent.setCurrPage(0);
        }
        List<String> oldPages = this.parent.pagesAsList();
        int newBookSize = this.parent.getBookPageCount() - (to - from + 1);
        for (int i = this.parent.getBookPageCount() - 1; i >= from; --i) {
            if (i > newBookSize - 1) {
                if (i == 0) {
                    this.parent.setPageText(0, "");
                    continue;
                }
                this.parent.removePage(i);
                continue;
            }
            this.parent.setPageText(i, oldPages.get(i + (to - from) + 1));
        }
        if (this.parent.getBookPageCount() == 0) {
            this.parent.insertNewPage(0, "");
        }
        this.bookChanged(true);
    }

    private void collapseTop() {
        String trimmed = this.parent.getPageText(this.parent.getCurrPage()).trim();
        this.parent.setPageText(this.parent.getCurrPage(), trimmed);
        this.bookChanged(false);
        Ghostwriter.PRINTER.gamePrint(Printer.GRAY + "Leading whitespace removed");
    }

    public void clipboardToBook(Clipboard fromBook) {
        this.setBookTitle(fromBook.title);
        this.parent.setBookTitle(this.bookTitle);
        this.parent.replaceBookPages(fromBook.pages);
        if (this.parent.getBookPageCount() == 0) {
            this.parent.insertNewPage(0, "");
        }
        this.bookChanged(true);
    }

    public void enableAutoReload(File path, Clipboard initialBookState) {
        this.autoReloadClipboard = initialBookState;
        this.autoReloadFile = path;
        this.autoReloadLastModified = path.lastModified();
        this.autoReloadLastCheck = System.currentTimeMillis();
        this.updateButtons();
    }

    public void tick() {
        if (this.autoReloadFile != null && System.currentTimeMillis() - this.autoReloadLastCheck > 1000L) {
            if (this.autoReloadFile.exists()) {
                if (this.autoReloadFile.lastModified() != this.autoReloadLastModified) {
                    FileHandler f = new FileHandler(this.autoReloadClipboard);
                    if (f.loadBook(this.autoReloadFile)) {
                        this.clipboardToBook(this.autoReloadClipboard);
                        Ghostwriter.PRINTER.gamePrint(Printer.AQUA + "Automatically loaded new book version");
                        this.autoReloadLastModified = this.autoReloadFile.lastModified();
                    } else {
                        Ghostwriter.PRINTER.gamePrint(Printer.RED + "Book failed to automatically reload!");
                        this.disableAutoReload();
                    }
                    this.autoReloadLastCheck = System.currentTimeMillis();
                }
            } else {
                Ghostwriter.PRINTER.gamePrint(Printer.RED + "Source file disappeared!");
                this.disableAutoReload();
            }
        }
    }

    public void disableAutoReload() {
        this.autoReloadFile = null;
        Ghostwriter.PRINTER.gamePrint(Printer.AQUA + "Auto reload disabled");
        this.updateButtons();
    }

    public void updateButtons() {
        this.parent.updateVanillaButtons();
        if (!this.buttonsInitialized) {
            return;
        }
        for (Button b : this.buttonsHideWhileSigning) {
            b.f_93624_ = !this.parent.isBookBeingSigned();
        }
        for (Button b : this.buttonsEditOnly) {
            b.f_93624_ = this.bookIsEditable && b.f_93624_;
        }
        if (this.selectedPageA < -1 || this.selectedPageA >= this.parent.getBookPageCount()) {
            this.selectedPageA = -1;
        }
        if (this.selectedPageB < -1 || this.selectedPageB >= this.parent.getBookPageCount()) {
            this.selectedPageB = -1;
        }
        if (this.selectedPageA >= 0 && this.selectedPageB >= 0 && this.selectedPageA != this.selectedPageB) {
            this.buttonCopySelectedPages.f_93623_ = true;
            String xPages = Math.abs(this.selectedPageB - this.selectedPageA) + 1 + " Pages";
            this.buttonCopySelectedPages.m_93666_((Component)Component.m_237115_((String)("Copy " + xPages)));
            this.buttonCutMultiplePages.m_93666_((Component)Component.m_237115_((String)("Cut " + xPages)));
            this.buttonRemoveSelectedPages.m_93666_((Component)Component.m_237115_((String)("Remove " + xPages)));
            this.buttonSelectPageA.m_93666_((Component)Component.m_237115_((String)("A: " + (this.selectedPageA + 1))));
            this.buttonSelectPageB.m_93666_((Component)Component.m_237115_((String)("B: " + (this.selectedPageB + 1))));
        } else {
            this.buttonCopySelectedPages.m_93666_((Component)Component.m_237115_((String)"Copy This Page"));
            this.buttonCutMultiplePages.m_93666_((Component)Component.m_237115_((String)"Cut This Page"));
            this.buttonRemoveSelectedPages.m_93666_((Component)Component.m_237115_((String)"Remove This Page"));
            this.buttonSelectPageA.m_93666_((Component)Component.m_237115_((String)"A"));
            this.buttonSelectPageB.m_93666_((Component)Component.m_237115_((String)"B"));
            if (this.selectedPageA >= 0) {
                this.buttonSelectPageA.m_93666_((Component)Component.m_237115_((String)("A: " + (this.selectedPageA + 1))));
            }
            if (this.selectedPageB >= 0) {
                this.buttonSelectPageB.m_93666_((Component)Component.m_237115_((String)("B: " + (this.selectedPageB + 1))));
            }
        }
        this.buttonPasteBook.f_93623_ = Ghostwriter.GLOBAL_CLIPBOARD.bookInClipboard;
        boolean bl = this.buttonPasteMultiplePages.f_93623_ = Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() > 0;
        if (this.buttonPasteMultiplePages.f_93623_) {
            this.buttonPasteMultiplePages.m_93666_((Component)Component.m_237115_((String)("Paste " + Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() + " Page" + (Ghostwriter.GLOBAL_CLIPBOARD.miscPages.size() == 1 ? "" : "s"))));
        } else {
            this.buttonPasteMultiplePages.m_93666_((Component)Component.m_237115_((String)"Paste Multiple"));
        }
        this.buttonDisableAutoReload.f_93623_ = this.autoReloadFile != null;
    }

    private Button addPageButton(int x, int y, String label, Button.OnPress action, boolean hideInReadOnlyMode) {
        int width = 120;
        int height = 20;
        Button b = this.parent.addGhostButton(GuiUtils.buttonFactory(x, y, width, height, label, action));
        this.buttonsHideWhileSigning.add(b);
        if (hideInReadOnlyMode) {
            this.buttonsEditOnly.add(b);
        }
        return b;
    }

    private Button addColorFormatButton(int y, String label, String formattingCode) {
        Button b = this.addPageButton(this.colorFormatButtonX, y, label, pressed_button -> this.parent.addFormattingCode(formattingCode), true);
        b.m_93674_(20);
        this.colorFormatButtonX += 20;
        return b;
    }

    public void init() {
        this.buttonsEditOnly.clear();
        this.buttonsHideWhileSigning.clear();
        int rightXPos = this.screen.f_96543_ - 125;
        this.addPageButton(5, 5, "File Browser", pressed_button -> MINECRAFT.m_91152_((Screen)new GhostwriterFileBrowserScreen(this)), false);
        this.buttonDisableAutoReload = this.addPageButton(5, 45, "Disable AutoReload", pressed_button -> this.disableAutoReload(), true);
        this.addPageButton(5, 70, "Add Signature Pages", pressed_button -> this.addSignaturePages(), true);
        this.addPageButton(5, 95, "Preview Signed Book", pressed_button -> MINECRAFT.m_91152_((Screen)new GhostwriterSignedPreviewScreen((GhostwriterEditBookScreen)this.screen)), true);
        this.addPageButton(rightXPos, 5, "Copy Book", pressed_button -> this.copyBook(), false);
        this.buttonPasteBook = this.addPageButton(rightXPos, 25, "Paste Book", pressed_button -> this.pasteBook(), true);
        this.buttonSelectPageA = this.addPageButton(rightXPos, 50, "A", pressed_button -> {
            this.selectedPageA = this.parent.getCurrPage();
            this.updateButtons();
        }, false);
        this.buttonSelectPageA.m_93674_(60);
        int buttonBX = rightXPos + 60;
        this.buttonSelectPageB = this.addPageButton(buttonBX, 50, "B", pressed_button -> {
            this.selectedPageB = this.parent.getCurrPage();
            this.updateButtons();
        }, false);
        this.buttonSelectPageB.m_93674_(60);
        this.buttonCopySelectedPages = this.addPageButton(rightXPos, 70, "Copy This Page", pressed_button -> this.copySelectedPagesToClipboard(), false);
        this.buttonCutMultiplePages = this.addPageButton(rightXPos, 90, "Cut This Page", pressed_button -> this.cutMultiplePages(), true);
        this.buttonRemoveSelectedPages = this.addPageButton(rightXPos, 110, "Remove This Page", pressed_button -> this.removePages(this.selectedPageA, this.selectedPageB), true);
        this.buttonPasteMultiplePages = this.addPageButton(rightXPos, 130, "Paste This Page", pressed_button -> this.pasteMultiplePages(this.parent.getCurrPage()), true);
        this.addPageButton(rightXPos, 155, "Insert Blank Page", pressed_button -> this.insertPage(), true);
        this.addPageButton(rightXPos, 175, "Remove Top Space", pressed_button -> this.collapseTop(), true);
        this.colorFormatButtonX = this.screen.f_96543_ / 2 - 160;
        int colorButY = this.screen.f_96544_ - 40;
        this.addColorFormatButton(colorButY, "\u00a70A", "\u00a70");
        this.addColorFormatButton(colorButY, "\u00a71A", "\u00a71");
        this.addColorFormatButton(colorButY, "\u00a72A", "\u00a72");
        this.addColorFormatButton(colorButY, "\u00a73A", "\u00a73");
        this.addColorFormatButton(colorButY, "\u00a74A", "\u00a74");
        this.addColorFormatButton(colorButY, "\u00a75A", "\u00a75");
        this.addColorFormatButton(colorButY, "\u00a76A", "\u00a76");
        this.addColorFormatButton(colorButY, "\u00a77A", "\u00a77");
        this.addColorFormatButton(colorButY, "\u00a78A", "\u00a78");
        this.addColorFormatButton(colorButY, "\u00a79A", "\u00a79");
        this.addColorFormatButton(colorButY, "\u00a7aA", "\u00a7a");
        this.addColorFormatButton(colorButY, "\u00a7bA", "\u00a7b");
        this.addColorFormatButton(colorButY, "\u00a7cA", "\u00a7c");
        this.addColorFormatButton(colorButY, "\u00a7dA", "\u00a7d");
        this.addColorFormatButton(colorButY, "\u00a7eA", "\u00a7e");
        this.addColorFormatButton(colorButY, "\u00a7fA", "\u00a7f");
        this.colorFormatButtonX = this.screen.f_96543_ / 2 - 100;
        int formatButY = this.screen.f_96544_ - 20;
        this.addColorFormatButton(formatButY, "\u00a7kA", "\u00a7k");
        this.addColorFormatButton(formatButY, "\u00a7lA", "\u00a7l");
        this.addColorFormatButton(formatButY, "\u00a7mA", "\u00a7m");
        this.addColorFormatButton(formatButY, "\u00a7nA", "\u00a7n");
        this.addColorFormatButton(formatButY, "\u00a7oA", "\u00a7o");
        this.addColorFormatButton(formatButY, "Reset Formatting", "\u00a7r").m_93674_(100);
        this.buttonsInitialized = true;
        this.updateButtons();
    }

    public void saveBookToDisk(File filepath) {
        List<String> pages = this.parent.pagesAsList();
        Ghostwriter.FILE_HANDLER.saveBookToGHBFile(this.bookTitle, this.bookAuthor, pages, filepath);
    }
}

